package com.ejie.ab04b.dao.xa;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcTemplate;

/**
 * Clase abstracta que heredan los DAO que necesitan implementar transaciones XA
 * 
 * @author dcarranz
 * 
 */
public abstract class Ab04bTransactionalXADao implements Ab04bXAtransaction {

	/** Sistema de trazas del objeto */
	private static final Logger LOGGER = LoggerFactory
			.getLogger(Ab04bTransactionalXADao.class);

	// CHECKSTYLE:OFF - nos vemos obigados a dar aceso protegido por
	// la arquitectura subyacente
	protected JdbcTemplate jdbcTemplate;
	protected JdbcTemplate jdbcTemplateXA;

	// CHECKSTYLE:ON - nos vemos obigados a dar aceso protegido por la
	// arquitectura subyacente
	private boolean isXA = false;

	/**
	 * Decide si la transacción utiliza un driver XA
	 * 
	 *  true si la transacción utiliza un driver XA, false eoc.
	 *
	 * @return true, if is xa
	 */
	public boolean isXA() {
		return this.isXA;
	}

	/**
	 * Establece si la transacción utiliza un driver XA
	 * 
	 *  isXA
	 *            true si la transacción utiliza un driver XA, false eoc.
	 *
	 * @param isXA the new xa
	 */
	public void setXA(boolean isXA) {
		this.isXA = isXA;
	}

	/**
	 * Establece el datasource XA
	 * 
	 *  dataSourceXA
	 *            el datasource XA.
	 *
	 * @param dataSourceXA the new data source XA
	 */
	@Resource()
	public abstract void setDataSourceXA(DataSource dataSourceXA);

	/**
	 * Establece el datasource
	 * 
	 *  dataSource
	 *            el datasource.
	 *
	 * @param dataSource the new data source
	 */
	@Resource()
	public abstract void setDataSource(DataSource dataSource);

	/**
	 * Devuelve la pantilla JDBC que corresponde a la transaccion que esta
	 * utilizando el DAO
	 * 
	 *  la pantilla JDBC-.
	 *
	 * @return the jdbc template
	 */
	protected JdbcTemplate obtaninJdbcTemplate() {
		if (this.isXA) {
			Ab04bTransactionalXADao.LOGGER.info("{}: se va a usar template XA",
					this.getClass().getName());
			return this.jdbcTemplateXA;
		}
		Ab04bTransactionalXADao.LOGGER.info("{}: se va a usar template NO XA",
				this.getClass().getName());
		return this.jdbcTemplate;
	}

	/**
	 * Devuelve la pantilla JDBC que corresponde a la transaccion que esta
	 * utilizando el DAO
	 * 
	 *  la pantilla JDBC-.
	 *
	 * @return the jdbc template
	 */
	protected JdbcTemplate obtaninJdbcTemplateNOXA() {
		return this.jdbcTemplate;
	}

	/**
	 * Devuelve la pantilla JDBC que corresponde a la transaccion que esta
	 * utilizando el DAO
	 * 
	 *  la pantilla JDBC-.
	 *
	 * @return the jdbc template
	 */
	protected JdbcTemplate obtaninJdbcTemplateXA() {
		return this.jdbcTemplateXA;
	}
}
